# Plik rozruchowy Pythona.

import atexit
import os

try:
    import readline
except ImportError:
    print("Uzupełnianie kodu niedostępne: moduł readline jest niedostępny.")
else:
    import rlcompleter

    # Uzupełnianie kodu klawiszem tabulacji.
    readline.parse_and_bind("tab: complete")

    # Ścieżka do pliku z historią z katalogu głównego użytkownika.
    # Możesz użyć własnej ścieżki.
    history_file = os.path.join(os.environ["HOME"], ".python_shell_history")
    try:
        readline.read_history_file(history_file)
    except IOError:
        pass

    atexit.register(readline.write_history_file, history_file)
    del os, history_file, readline, rlcompleter
